import type { SVGProps } from 'react';
interface CustomIconProps extends SVGProps<SVGSVGElement> {
    size?: number;
    fill?: string;
    stroke?: string;
    strokeWidth?: number;
    viewBox?: string;
}

const firewall = ({
    size = 24,
    fill = 'none',
    stroke = 'none',
    strokeWidth = 1,
    viewBox = '0 0 16 19',
    ...props
}:CustomIconProps) => (
    <svg
        width={size}
        height={size}
        fill={fill}
        stroke={stroke}
        strokeWidth={strokeWidth}
        viewBox={viewBox}
        strokeLinecap="round"
        strokeLinejoin="round"
        xmlns="http://www.w3.org/2000/svg"
        {...props}
    >
        <path
            d="M0 16.5V2.5C0 1.95 0.195833 1.47917 0.5875 1.0875C0.979167 0.695833 1.45 0.5 2 0.5H14C14.55 0.5 15.0208 0.695833 15.4125 1.0875C15.8042 1.47917 16 1.95 16 2.5V8.5C16 9.05 15.8042 9.52083 15.4125 9.9125C15.0208 10.3042 14.55 10.5 14 10.5H2V12.5H6C6.28333 12.5 6.52083 12.5958 6.7125 12.7875C6.90417 12.9792 7 13.2167 7 13.5C7 13.7833 6.90417 14.0208 6.7125 14.2125C6.52083 14.4042 6.28333 14.5 6 14.5H2V16.5H6C6.28333 16.5 6.52083 16.5958 6.7125 16.7875C6.90417 16.9792 7 17.2167 7 17.5C7 17.7833 6.90417 18.0208 6.7125 18.2125C6.52083 18.4042 6.28333 18.5 6 18.5H2C1.45 18.5 0.979167 18.3042 0.5875 17.9125C0.195833 17.5208 0 17.05 0 16.5ZM11.4 15.7L14.25 12.85C14.4333 12.6667 14.6667 12.575 14.95 12.575C15.2333 12.575 15.4667 12.6667 15.65 12.85C15.8333 13.0333 15.925 13.2667 15.925 13.55C15.925 13.8333 15.8333 14.0667 15.65 14.25L12.1 17.8C11.9 18 11.6667 18.1 11.4 18.1C11.1333 18.1 10.9 18 10.7 17.8L9.3 16.4C9.11667 16.2167 9.025 15.9833 9.025 15.7C9.025 15.4167 9.11667 15.1833 9.3 15C9.48333 14.8167 9.71667 14.725 10 14.725C10.2833 14.725 10.5167 14.8167 10.7 15L11.4 15.7ZM2 8.5H7V6.5H2V8.5ZM9 8.5H14V6.5H9V8.5ZM2 4.5H7V2.5H2V4.5ZM9 4.5H14V2.5H9V4.5Z"
        />
    </svg>
);

export default firewall;