import React, { Component, Fragment } from 'react';

import '../../../css/admin/modal/bulk-edit.scss';

import Api from '../../shared/Api';
import Actions from './Actions';
import Header from '../general/Header';
import Footer from '../general/Footer';
export default class BulkEdit extends Component {
    constructor(props) {
        super(props);

        this.state = {
            linkIds: props.args.hasOwnProperty( 'linkIds' ) ? props.args.linkIds : [],
            action: false,
            saveCallback: props.args.hasOwnProperty( 'saveCallback' ) ? props.args.saveCallback : false,
            savingChanges: false,
        };

        // Bind functions.
        this.onActionChange = this.onActionChange.bind(this);
        this.onBulkEditLinks = this.onBulkEditLinks.bind(this);
        this.allowCloseModal = this.allowCloseModal.bind(this);
    }

    onActionChange(action) {
        this.setState({
            action,
        });
    }

    onBulkEditLinks() {
        if ( this.state.action ) {
            this.setState({
                savingChanges: true,
            }, () => {
                Api.bulkEdit(this.state.linkIds, this.state.action).then(() => {
                    this.setState({
                        savingChanges: false,
                    }, () => {
                        if ( 'function' === typeof this.state.saveCallback ) {
                            this.state.saveCallback();
                        }
                        this.props.maybeCloseModal();
                    });
                });
            });
        }
    }

    allowCloseModal() {
        return ! this.state.savingChanges;
    }

    changesMade() {
        if ( ! this.state.action || ! this.state.action.type ) {
            return false;
        } else {
            return Array.isArray( this.state.action.options ) && this.state.action.options.length === 0 ? false : true;
        }
    }

    render() {
        return (
            <Fragment>
                <Header
                    onCloseModal={ this.props.maybeCloseModal }
                >{ `${ eafl_admin_manage_modal.text.manage.links_bulk_edit } ${ this.state.linkIds.length } ${ eafl_admin_manage_modal.text.manage.links }` }</Header>
                <div className="eafl-admin-modal-content">
                    <Actions
                        action={ this.state.action }
                        onActionChange={ this.onActionChange }
                    />
                </div>
                <Footer
                    savingChanges={ this.state.savingChanges }
                >
                    <button
                        className="button button-primary"
                        onClick={ this.onBulkEditLinks }
                        disabled={ ! this.changesMade() }
                    >
                        { eafl_admin_manage_modal.text.modal.bulk_edit_links }
                    </button>
                </Footer>
            </Fragment>
        );
    }
}