import React from 'react';
import he from 'he';
 
import CopyToClipboardIcon from '../../shared/CopyToClipboardIcon';
import Api from '../../shared/Api';
import Icon from '../../shared/Icon';

export default {
    getColumns( links ) {
        let categories = eafl_admin_manage_modal.categories.map(cat => { return {id: cat.term_id, label: `${cat.name} (${cat.count})` } } );
        categories.sort((a,b) => a.label.localeCompare(b.label));

        let columns = [{
            Header: eafl_admin_manage_modal.text.manage.links_bulk_edit,
            id: 'bulk_edit',
            className: 'eafl-admin-table-checkbox-container',
            headerClassName: 'eafl-admin-table-checkbox-container',
            sortable: false,
            width: 30,
            Filter: () => (
                <input
                    type="checkbox"
                    checked={ 1 === links.state.selectedAllRows }
                    ref={ input => {
                        if (input) {
                            input.indeterminate = links.state.selectedAllRows === 2;
                        }
                    }}
                    onChange={ () => links.toggleSelectAll() }
                />
            ),
            Cell: row => (
                <input
                    type="checkbox"
                    checked={ true === links.state.selectedRows[row.original.id] }
                    onChange={ () => links.toggleSelectRow(row.original.id) }
                />
            ),
        },{
            Header: eafl_admin_manage_modal.text.manage.table_sort,
            id: 'actions',
            headerClassName: 'eafl-admin-table-help-text',
            sortable: false,
            width: 70,
            Filter: () => (
                <div>
                    { eafl_admin_manage_modal.text.manage.table_filter }
                </div>
            ),
            Cell: row => (
                <div className="eafl-admin-manage-actions">
                    <Icon
                        type="edit"
                        title={ eafl_admin_manage_modal.text.manage.links_edit }
                        onClick={() => {
                            EAFL_Modal.open('edit', { link: row.original, saveCallback: () => links.refreshData() });
                        }}
                    />
                    <Icon
                        type="delete"
                        title={ eafl_admin_manage_modal.text.manage.links_delete }
                        onClick={() => {
                            if(confirm(`Are you sure you want to delete the "${row.original.name}" link?`)) {
                                Api.deleteLink(row.original.id).then(() => links.refreshData());
                            }
                        }}
                    />
                </div>
            ),
        },{
            Header: eafl_admin_manage_modal.text.manage.links_id,
            id: 'id',
            accessor: 'id',
            width: 65,
        },{
            Header: eafl_admin_manage_modal.text.manage.links_date,
            id: 'date',
            accessor: 'date',
            width: 150,
        },{
            Header: eafl_admin_manage_modal.text.manage.links_categories,
            id: 'categories',
            accessor: 'categories',
            sortable: false,
            Filter: ({ filter, onChange }) => (
                <select
                    onChange={event => onChange(event.target.value)}
                    style={{ width: '100%', fontSize: '1em' }}
                    value={filter ? filter.value : 'all'}
                >
                    <optgroup label={ eafl_admin_manage_modal.text.manage.links_categories_general }>
                        <option value="all">{ eafl_admin_manage_modal.text.manage.links_categories_all }</option>
                        <option value="none">{ eafl_admin_manage_modal.text.manage.links_categories_none }</option>
                        <option value="any">{ eafl_admin_manage_modal.text.manage.links_categories_any }</option>
                    </optgroup>
                    <optgroup label={ eafl_admin_manage_modal.text.manage.links_categories_terms }>
                        {
                            categories.map((term, index) => (
                                <option value={term.id} key={index}>{ he.decode(term.label) }</option>
                            ))
                        }
                    </optgroup>
                </select>
            ),
            Cell: row => {
                const names = row.value.map(t => t.name);
    
                return (
                    <div>{ he.decode( names.join(', ') ) }</div>
                )
            },
            width: 300,
        },{
            Header: eafl_admin_manage_modal.text.manage.links_name,
            id: 'name',
            accessor: 'name',
            width: 300,
        },{
            Header: eafl_admin_manage_modal.text.manage.links_description,
            id: 'description',
            accessor: 'description',
            width: 300,
            Cell: row => he.decode(row.value),
        },{
            Header: eafl_admin_manage_modal.text.manage.links_clicks,
            id: 'clicks',
            accessor: 'clicks',
            width: 120,
            Cell: row => {
                return (
                    <div className="eafl-admin-manage-links-clicks-container">
                        <div
                            style={ 0 < row.value.all ? {} : { visibility: 'hidden' }}
                        >
                            <Icon
                                type="delete"
                                title={ eafl_admin_manage_modal.text.manage.links_clicks_delete }
                                onClick={() => {
                                    if(confirm(`Are you sure you want to reset the clicks for "${row.original.name}"?`)) {
                                        Api.resetClicks(row.original.id).then(() => links.refreshData());
                                    }
                                }}
                            />
                        </div>
                        <div>
                            <div>{ row.value.month } <span className="eafl-admin-manage-links-clicks-text">{ eafl_admin_manage_modal.text.manage.links_clicks_month }</span></div>
                            <div>{ row.value.all } <span className="eafl-admin-manage-links-clicks-text">{ eafl_admin_manage_modal.text.manage.links_clicks_lifetime }</span></div>
                        </div>
                    </div>
                )
            },
        },{
            Header: eafl_admin_manage_modal.text.manage.links_text,
            id: 'text',
            accessor: 'text',
            width: 300,
            Cell: row => {    
                return (
                    <div>{ row.value[0] }</div>
                )
            },
        },{
            Header: eafl_admin_manage_modal.text.manage.links_cloaking,
            id: 'cloak',
            accessor: 'cloak',
            width: 250,
            Filter: ({ filter, onChange }) => (
                <select
                    onChange={event => onChange(event.target.value)}
                    style={{ width: '100%', fontSize: '1em' }}
                    value={filter ? filter.value : 'all'}
                >
                    <option value="all">{ eafl_admin_manage_modal.text.manage.links_cloaking_any }</option>
                    {
                        eafl_admin_manage_modal.options.cloak.map((option, index) => (
                            <option value={option.value} key={index}>{ option.label }</option>
                        ))
                    }
                </select>
            ),
            Cell: row => {
                const option = eafl_admin_manage_modal.options.cloak.find((option) => option.value === row.value );
                return (
                    <div>
                        {
                            option
                            && option.label
                        }
                    </div>
                )
            },
        },{
            Header: eafl_admin_manage_modal.text.manage.links_target,
            id: 'target',
            accessor: 'target',
            width: 250,
            Filter: ({ filter, onChange }) => (
                <select
                    onChange={event => onChange(event.target.value)}
                    style={{ width: '100%', fontSize: '1em' }}
                    value={filter ? filter.value : 'all'}
                >
                    <option value="all">{ eafl_admin_manage_modal.text.manage.links_target_any }</option>
                    {
                        eafl_admin_manage_modal.options.target.map((option, index) => (
                            <option value={option.value} key={index}>{ option.label }</option>
                        ))
                    }
                </select>
            ),
            Cell: row => {
                const option = eafl_admin_manage_modal.options.target.find((option) => option.value === row.value );
                return (
                    <div>
                        {
                            option
                            && option.label
                        }
                    </div>
                )
            },
        },{
            Header: eafl_admin_manage_modal.text.manage.links_redirect_type,
            id: 'redirect_type',
            accessor: 'redirect_type',
            width: 250,
            Filter: ({ filter, onChange }) => (
                <select
                    onChange={event => onChange(event.target.value)}
                    style={{ width: '100%', fontSize: '1em' }}
                    value={filter ? filter.value : 'all'}
                >
                    <option value="all">{ eafl_admin_manage_modal.text.manage.links_redirect_type_any }</option>
                    {
                        eafl_admin_manage_modal.options.redirect_type.map((option, index) => (
                            <option value={option.value} key={index}>{ option.label }</option>
                        ))
                    }
                </select>
            ),
            Cell: row => {
                const option = eafl_admin_manage_modal.options.redirect_type.find((option) => option.value == row.value );
                return (
                    <div>
                        {
                            option
                            && option.label
                        }
                    </div>
                )
            },
        },{
            Header: eafl_admin_manage_modal.text.manage.links_nofollow,
            id: 'nofollow',
            accessor: 'nofollow',
            width: 250,
            Filter: ({ filter, onChange }) => (
                <select
                    onChange={event => onChange(event.target.value)}
                    style={{ width: '100%', fontSize: '1em' }}
                    value={filter ? filter.value : 'all'}
                >
                    <option value="all">{ eafl_admin_manage_modal.text.manage.links_nofollow_any }</option>
                    {
                        eafl_admin_manage_modal.options.nofollow.map((option, index) => (
                            <option value={option.value} key={index}>{ option.label }</option>
                        ))
                    }
                </select>
            ),
            Cell: row => {
                const option = eafl_admin_manage_modal.options.nofollow.find((option) => option.value === row.value );
                return (
                    <div>
                        {
                            option
                            && option.label
                        }
                    </div>
                )
            },
        },{
            Header: eafl_admin_manage_modal.text.manage.links_shortlink,
            id: 'shortlink',
            accessor: 'shortlink',
            width: 400,
            Cell: row => {
                const cloak = eafl_admin_manage_modal.options.cloak.find((option) => option.value === row.original.cloak );
                if ( cloak && 'no' === cloak.actual ) {
                    return null;
                }

                return (
                    <div className="eafl-admin-table-links-shortlink-container">
                        <CopyToClipboardIcon text={row.value} />
                        <a href={row.value} target="_blank" className="eafl-admin-table-links-shortlink">{row.value}</a>
                    </div>
                )
            },
        },{
            Header: eafl_admin_manage_modal.text.manage.links_url,
            id: 'url',
            accessor: 'url',
            width: 400,
            Cell: row => {
                if ( ! row.value ) {
                    return null;
                }

                return (
                    <div className="eafl-admin-table-links-url-container">
                        <CopyToClipboardIcon text={row.value} />
                        <a href={row.value} target="_blank" className="eafl-admin-table-links-url">{row.value}</a>
                    </div>
                )
            },
        }];

        return columns;
    }
};