import React from 'react';
import SVG from 'react-inlinesvg';

import '../../css/admin/shared/icon.scss';
import Tooltip from './Tooltip';

import IconClose from '../../icons/close.svg';
import IconDelete from '../../icons/delete.svg';
import IconEdit from '../../icons/edit.svg';
import IconLink from '../../icons/link.svg';
import IconMerge from '../../icons/merge.svg';
 
const icons = {
    close: IconClose,
    delete: IconDelete,
    edit: IconEdit,
    link: IconLink,
    merge: IconMerge,
};

const Icon = (props) => {
    let icon = icons.hasOwnProperty(props.type) ? icons[props.type] : false;

    if ( !icon ) {
        return null;
    }

    return (
        <Tooltip content={props.title}>
            <span
                className='eafl-admin-icon'
                onClick={props.onClick}
                title={props.title}
            >
                <SVG
                    src={icon}
                />
            </span>
        </Tooltip>
    );
}
export default Icon;