import React from 'react';
import he from 'he';
import CreatableSelect from 'react-select/lib/Creatable';
 
const FieldCategories = (props) => {
    const categories = eafl_admin_manage_modal.categories;
    let categoryOptions = [];
    let selectedCategories = [];

    for ( let category of categories ) {
        const categoryOption = {
            value: category.term_id,
            label: he.decode( category.name ),
        };

        categoryOptions.push(categoryOption);

        if ( props.value.find((elem) => elem.term_id === category.term_id || elem.name === category.term_id ) ) {
            selectedCategories.push(categoryOption);
        }
    }

    const customProps = props.custom ? props.custom : {};

    return (
        <CreatableSelect
            isMulti
            options={categoryOptions}
            value={selectedCategories}
            onChange={(value) => {
                let newValue = [];

                for ( let category of value ) {
                    if ( category.hasOwnProperty('__isNew__') && category.__isNew__ ) {
                        eafl_admin_manage_modal.categories.push({
                            term_id: category.label,
                            name: category.label,
                        });
                    }

                    let selectedCategory = eafl_admin_manage_modal.categories.find((cat) => cat.term_id === category.value);

                    if ( selectedCategory ) {
                        newValue.push(selectedCategory);
                    }
                }

                props.onChange(newValue);
            }}
            { ...customProps }
        />
    );
}
export default FieldCategories;