import React from 'react';

import '../../../css/admin/manage/select-columns.scss';
 
const SelectColumns = (props) => {
    return (
        <div className="eafl-admin-manage-select-columns-container">
            <h4>{ eafl_admin_manage_modal.text.manage.columns_show_hide }</h4>
            <div className="eafl-admin-manage-select-columns">
            {
                props.columns.map( (column, index) => {
                    if ( 'actions' === column.id ) {
                        return null;
                    }

                    return (
                        <span className="eafl-admin-manage-select-columns-column" key={index}>
                            <input
                                id={`eafl-admin-manage-select-columns-column-${column.id}`}
                                type="checkbox"
                                checked={ props.selectedColumns.includes(column.id) }
                                onChange={(event) => props.onColumnsChange(column.id, event.target.checked)}
                            />
                            <label htmlFor={`eafl-admin-manage-select-columns-column-${column.id}`}>{ column.Header }</label>
                        </span>
                    );
                })
            }
            </div>
        </div>
    );
}
export default SelectColumns;