import React, { Fragment } from 'react';

import FieldCategories from '../link/field/FieldCategories';
import FieldRadio from '../link/field/FieldRadio';
 
const Actions = (props) => {
    const selectedAction = props.action ? props.action.type : false;
    const actionOptions = [
        { value: 'add-categories', label: eafl_admin_manage_modal.text.modal.bulk_add_categories, default: [] },
        { value: 'remove-categories', label: eafl_admin_manage_modal.text.modal.bulk_remove_categories, default: [] },
        { value: 'change-cloaking', label: eafl_admin_manage_modal.text.modal.bulk_change_cloaking, default: 'default' },
        { value: 'change-target', label: eafl_admin_manage_modal.text.modal.bulk_change_target, default: 'default' },
        { value: 'change-redirect-type', label: eafl_admin_manage_modal.text.modal.bulk_change_redirect_type, default: 'default' },
        { value: 'change-nofollow', label: eafl_admin_manage_modal.text.modal.bulk_change_nofollow, default: 'default' },
        { value: 'reset-clicks', label: eafl_admin_manage_modal.text.modal.bulk_reset_clicks, default: false },
        { value: 'delete', label: eafl_admin_manage_modal.text.modal.bulk_delete_links, default: false },
    ];

    return (
        <Fragment>
            <div className="eafl-admin-modal-bulk-edit-label">{ eafl_admin_manage_modal.text.modal.bulk_select_action }</div>
            <div className="eafl-admin-modal-bulk-edit-actions">
                {
                    actionOptions.map((option) => (
                        <div className="eafl-admin-modal-bulk-edit-action" key={option.value}>
                            <input
                                type="radio"
                                value={option.value}
                                name={`eafl-admin-radio-bulk-edit-action`}
                                id={`eafl-admin-radio-bulk-edit-action-${option.value}`}
                                checked={selectedAction === option.value}
                                onChange={() => {
                                    const newAction = {
                                        type: option.value,
                                        options: option.default,
                                    }
                
                                    props.onActionChange(newAction);
                                }}
                            /><label htmlFor={`eafl-admin-radio-bulk-edit-action-${option.value}`}>{ option.label }</label>
                        </div>
                    ))
                }
            </div>
            {
                selectedAction && false !== props.action.options
                &&
                <Fragment>
                    <div className="eafl-admin-modal-bulk-edit-label">{ eafl_admin_manage_modal.text.modal.bulk_select_options }</div>
                    <div className="eafl-admin-modal-bulk-edit-options">
                        {
                            ( 'add-categories' === selectedAction || 'remove-categories' === selectedAction )
                            &&
                            <FieldCategories
                                custom={{
                                    menuPlacement: 'top',
                                    maxMenuHeight: 250,
                                }}
                                value={props.action.options}
                                onChange={(categories) => {
                                    const newAction = {
                                        ...props.action,
                                        options: categories,
                                    }
                
                                    props.onActionChange(newAction);
                                }}
                            />
                        }
                        {
                            'change-cloaking' === selectedAction
                            &&
                            <FieldRadio
                                id="cloak"
                                options={eafl_admin_manage_modal.options.cloak}
                                value={props.action.options}
                                onChange={(value) => {
                                    const newAction = {
                                        ...props.action,
                                        options: value,
                                    }
                
                                    props.onActionChange(newAction);
                                }}
                            />
                        }
                        {
                            'change-target' === selectedAction
                            &&
                            <FieldRadio
                                id="target"
                                options={eafl_admin_manage_modal.options.target}
                                value={props.action.options}
                                onChange={(value) => {
                                    const newAction = {
                                        ...props.action,
                                        options: value,
                                    }
                
                                    props.onActionChange(newAction);
                                }}
                            />
                        }
                        {
                            'change-redirect-type' === selectedAction
                            &&
                            <FieldRadio
                                id="redirect-type"
                                options={eafl_admin_manage_modal.options.redirect_type}
                                value={props.action.options}
                                onChange={(value) => {
                                    const newAction = {
                                        ...props.action,
                                        options: value,
                                    }
                
                                    props.onActionChange(newAction);
                                }}
                            />
                        }
                        {
                            'change-nofollow' === selectedAction
                            &&
                            <FieldRadio
                                id="nofollow"
                                options={eafl_admin_manage_modal.options.nofollow}
                                value={props.action.options}
                                onChange={(value) => {
                                    const newAction = {
                                        ...props.action,
                                        options: value,
                                    }
                
                                    props.onActionChange(newAction);
                                }}
                            />
                        }
                    </div>
                </Fragment>
            }
        </Fragment>
    );
}
export default Actions;