import React, { Component } from 'react';
import Modal from 'react-modal';

import '../../css/admin/modal/app.scss';

import BulkEdit from './bulk-edit';
import Insert from './insert';
import Link from './link';
import Text from './text';

Modal.setAppElement( '#eafl-admin-modal' );

export default class App extends Component {
    constructor() {
        super();
    
        this.state = {
            modalIsOpen: false,
            mode: '',
            args: {},
        };

        this.content = React.createRef();

        this.close = this.close.bind(this);
        this.closeIfAllowed = this.closeIfAllowed.bind(this);
    }

    open( mode, args ) {
        if ( ! this.state.modalIsOpen ) {
            this.setState({
                modalIsOpen: true,
                mode,
                args,
            });
        }
    }

    close(callback = false) { 
        this.setState({
            modalIsOpen: false,
        }, () => {
            if ( 'function' === typeof callback ) {
                callback();
            }
        });
    }

    closeIfAllowed(callback = false) {
        const checkFunction = this.content.current.hasOwnProperty( 'allowCloseModal' ) ? this.content.current.allowCloseModal : false;

        if ( ! checkFunction || checkFunction() ) {
            this.close(callback);
        }
    }

    render() {
        let content = null;

        const props = {
            ref: this.content,
            mode: this.state.mode,
            args: this.state.args,
            maybeCloseModal: this.closeIfAllowed,
        }

        switch ( this.state.mode ) {
            case 'edit':
            case 'create':
                content = (
                    <Link { ...props } />
                );
                break;
            case 'insert':
                content = (
                    <Insert { ...props } />
                );
                break;
            case 'bulk-edit':
                content = (
                    <BulkEdit { ...props } />
                );
                break;
            case 'text':
                content = (
                    <Text { ...props } />
                );
                break;
            default:
                return null;
        }

        return (
            <Modal
                isOpen={ this.state.modalIsOpen }
                onRequestClose={ this.closeIfAllowed }
                overlayClassName="eafl-admin-modal-overlay"
                className={`eafl-admin-modal eafl-admin-modal-${this.state.mode}`}
            >
                { content }
            </Modal>
        );
    }
}
