import React, { Component } from 'react';
import ReactTable from 'react-table';
import 'react-table/react-table.css';

import '../../../css/admin/shared/table.scss';

import Api from '../../shared/Api';
import Columns from './Columns';
import SelectColumns from '../general/SelectColumns';
import Totals from '../general/Totals';

export default class Categories extends Component {
    constructor(props) {
        super(props);

        // Use default selectedColumns or restore from LocalStorage.
        let selectedColumns = ['name', 'count'];
        let savedSelectedColumns = localStorage.getItem( 'eafl-admin-manage-categories-columns');

        if (savedSelectedColumns) {
            savedSelectedColumns = JSON.parse(savedSelectedColumns);

            if (Array.isArray(savedSelectedColumns)) {
                selectedColumns = savedSelectedColumns;
            }
        }

        this.state = {
            data: [],
            pages: null,
            filtered: false,
            total: false,
            loading: true,
            columns: Columns.getColumns( this.refreshData.bind(this) ),
            selectedColumns: selectedColumns,
        }
    }

    refreshData() {
        this.refReactTable.fireFetchData();
    }

    fetchData(state, instance) {
        this.setState({ loading: true });

        Api.getCategories({
            pageSize: state.pageSize,
            page: state.page,
            sorted: state.sorted,
            filtered: state.filtered,
        }).then(data => {
            if ( data ) {
                this.setState({
                    data: data.categories,
                    pages: data.pages,
                    filtered: data.filtered,
                    total: data.total,
                    loading: false,
                });
            }
        });
    }

    onColumnsChange(id, checked) {
        let selectedColumns = [ ...this.state.selectedColumns ];

        if (checked) {
            selectedColumns.push(id);
        } else {
            selectedColumns = selectedColumns.filter(c => c !== id);
        }

        this.setState({
            selectedColumns
        });

        localStorage.setItem( 'eafl-admin-manage-categories-columns', JSON.stringify( selectedColumns ) );
    }

    render() {
        const { data, pages, loading } = this.state;
        const selectedColumns = this.state.columns.filter(column => 'actions' === column.id || this.state.selectedColumns.includes(column.id));

        return (
            <div className="eafl-admin-manage-page">
                <div className="eafl-admin-manage-header">
                    <SelectColumns
                        onColumnsChange={this.onColumnsChange.bind(this)}
                        columns={this.state.columns}
                        selectedColumns={this.state.selectedColumns}
                    />
                    <button
                        className="button button-primary"
                        onClick={() => {
                            let name = prompt( eafl_admin_manage_modal.text.manage.category_create );
                            if( name && name.trim() ) {
                                Api.createCategory(name).then((data) => {
                                    this.refreshData()
                                    if ( ! data ) {
                                        alert( eafl_admin_manage_modal.text.manage.category_create_problem );
                                    } else {
                                        eafl_admin_manage_modal.categories.push({
                                            term_id: data.id,
                                            name: data.name,
                                            count: 0,
                                        });
                                    }
                                });
                            }
                        }}
                    >Create Category</button>
                </div>
                <div className="eafl-admin-manage-table-container">
                    <Totals
                        filtered={this.state.filtered}
                        total={this.state.total}
                    />
                    <ReactTable
                        ref={(refReactTable) => {this.refReactTable = refReactTable;}}
                        manual
                        columns={selectedColumns}
                        data={data}
                        pages={pages}
                        loading={loading}
                        onFetchData={this.fetchData.bind(this)}
                        defaultPageSize={25}
                        defaultSorted={[{
                            id: "id",
                            desc: true
                        }]}
                        filterable
                        resizable={false}
                        className="eafl-admin-manage-table eafl-admin-table -highlight"
                    />
                </div>
            </div>
        );
    }
}