import React from 'react';

import Field from './field';
 
const Fields = (props) => {
    const selectedCloakOption = eafl_admin_manage_modal.options.cloak.find((option) => option.value === props.link.cloak);
    const cloakedLink = 'yes' === selectedCloakOption.actual;

    return (
        <div className="eafl-admin-modal-link-fields">
            <div className="eafl-admin-modal-link-fields-group eafl-admin-modal-link-fields-group-organization">
                <div className="eafl-admin-modal-link-fields-group-header">{ eafl_admin_manage_modal.text.modal.link_organization }</div>
                <div className="eafl-admin-modal-link-fields">
                    <Field
                        id="name"
                        label={ eafl_admin_manage_modal.text.modal.link_name }
                        type="text"
                        value={props.link.name}
                        onChange={(value) => {
                            props.onLinkChange('name', value);
                        }}
                    />
                    <Field
                        id="description"
                        label={ eafl_admin_manage_modal.text.modal.link_description }
                        type="textarea"
                        value={props.link.description}
                        onChange={(value) => {
                            props.onLinkChange('description', value);
                        }}
                    />
                    <Field
                        id="categories"
                        label={ eafl_admin_manage_modal.text.modal.link_categories }
                        type="categories"
                        value={props.link.categories}
                        onChange={(value) => {
                            props.onLinkChange('categories', value);
                        }}
                    />
                </div>
            </div>
            <div className="eafl-admin-modal-link-fields-group eafl-admin-modal-link-fields-group-details">
                <div className="eafl-admin-modal-link-fields-group-header">{ eafl_admin_manage_modal.text.modal.link_details }</div>
                <div className="eafl-admin-modal-link-fields">
                    <Field
                        id="url"
                        label={ eafl_admin_manage_modal.text.modal.link_url }
                        type="text"
                        value={props.link.url}
                        onChange={(value) => {
                            props.onLinkChange('url', value);
                        }}
                    />
                    <Field
                        id="cloak"
                        label={ eafl_admin_manage_modal.text.modal.link_cloaking }
                        type="radio"
                        options={eafl_admin_manage_modal.options.cloak}
                        value={props.link.cloak}
                        onChange={(value) => {
                            props.onLinkChange('cloak', value);
                        }}
                    />
                    {
                        cloakedLink
                        &&
                        <Field
                            id="slug"
                            label={ eafl_admin_manage_modal.text.modal.link_slug }
                            type="slug"
                            value={props.link.slug}
                            onChange={(value) => {
                                props.onLinkChange('slug', value);
                            }}
                        />
                    }
                </div>
            </div>
            <div className="eafl-admin-modal-link-fields-group eafl-admin-modal-link-fields-group-shortcode">
                <div className="eafl-admin-modal-link-fields-group-header">{ eafl_admin_manage_modal.text.modal.link_shortcode }</div>
                <div className="eafl-admin-modal-link-fields">
                    <Field
                        id="text"
                        label={ eafl_admin_manage_modal.text.modal.link_text }
                        type="textVariants"
                        value={props.link.text}
                        onChange={(value) => {
                            props.onLinkChange('text', value);
                        }}
                    />
                </div>
            </div>
            <div className="eafl-admin-modal-link-fields-group eafl-admin-modal-link-fields-group-properties">
                <div className="eafl-admin-modal-link-fields">
                    <Field
                        id="target"
                        label={ eafl_admin_manage_modal.text.modal.link_target }
                        type="radio"
                        options={eafl_admin_manage_modal.options.target}
                        value={props.link.target}
                        onChange={(value) => {
                            props.onLinkChange('target', value);
                        }}
                    />
                    <Field
                        id="redirect_type"
                        label={ eafl_admin_manage_modal.text.modal.link_redirect_type }
                        type="radio"
                        options={eafl_admin_manage_modal.options.redirect_type}
                        value={props.link.redirect_type}
                        onChange={(value) => {
                            props.onLinkChange('redirect_type', value);
                        }}
                    />
                    <Field
                        id="nofollow"
                        label={ eafl_admin_manage_modal.text.modal.link_nofollow }
                        type="radio"
                        options={eafl_admin_manage_modal.options.nofollow}
                        value={props.link.nofollow}
                        onChange={(value) => {
                            props.onLinkChange('nofollow', value);
                        }}
                    />
                </div>
            </div>
        </div>
    );
}
export default Fields;