
import React, { Component } from 'react';

import Icon from './Icon';
import CopyToClipboard from 'react-copy-to-clipboard';

export default class CopyToClipboardIcon extends Component {
    constructor(props) {
        super(props);

        this.state = {
            copied: false,
        }
    }

    onCopy() {
        this.setState({
            copied: true,
        }, () => {
            setTimeout(() => {
                this.setState({
                    copied: false,
                });
            }, 2000);
        });
    }

    render() {
        return (
            <CopyToClipboard
                text={this.props.text}
                onCopy={this.onCopy.bind(this)}
            >
                <span
                    className="eafl-admin-table-links-url-container-copy"
                    style={{
                        opacity: this.state.copied ? 0.2 : 1
                    }}
                >
                    <Icon
                        type="link"
                        title={ this.state.copied ? eafl_admin_manage_modal.text.manage.clipboard_copied : eafl_admin_manage_modal.text.manage.clipboard_copy }
                    />
                </span>
            </CopyToClipboard>
        );
    }
}