const linkEndpoint = eafl_admin.endpoints.link;
const categoryEndpoint = eafl_admin.endpoints.category;
const manageEndpoint = eafl_admin.endpoints.manage;

let gettingLinks = false;
let gettingLinksNextArgs = false;

let gettingCategories = false;
let gettingCategoriesNextArgs = false;

export default {
    getLinks(args) {
        if ( ! gettingLinks ) {
            return this.getLinksDebounced(args);
        } else {
            gettingLinksNextArgs = args;
            return new Promise(r => r(false));
        }
    },
    getLinksDebounced(args) {
        gettingLinks = true;

        return fetch(`${manageEndpoint}/links`, {
            method: 'POST',
            headers: {
                'X-WP-Nonce': eafl_admin.api_nonce,
                'Accept': 'application/json',
                'Content-Type': 'application/json',
            },
            credentials: 'same-origin',
            body: JSON.stringify(args),
        }).then(response => {
            return response.json().then(json => {
                // Check if another request is queued.
                if ( gettingLinksNextArgs ) {
                    const newArgs = gettingLinksNextArgs;
                    gettingLinksNextArgs = false;

                    return this.getLinksDebounced(newArgs);
                } else {
                    // Return this request.
                    gettingLinks = false;
                    return response.ok ? json : false;
                }
            });
        });
    },
    getLink(id) {
        return fetch(`${linkEndpoint}/${id}`, {
            method: 'GET',
            headers: {
                'X-WP-Nonce': eafl_admin.api_nonce,
                'Accept': 'application/json',
                'Content-Type': 'application/json',
            },
            credentials: 'same-origin',
        }).then(function (response) {
            if ( response.ok ) {
                return response.json();
            } else {
                console.log(response);
                alert( 'Something went wrong. Please contact support.' );
                return false;
            }
        });
    },
    saveLink(asNewLink, link) {
        const data = {
            'post_status': 'publish',
            link
        };
        const endpoint = asNewLink ? linkEndpoint : `${linkEndpoint}/${link.id}`;

        return fetch(endpoint, {
            method: 'POST',
            headers: {
                'X-WP-Nonce': eafl_admin.api_nonce,
                'Accept': 'application/json',
                'Content-Type': 'application/json',
            },
            credentials: 'same-origin',
            body: JSON.stringify(data),
        }).then(function (response) {
            if ( response.ok ) {
                return response.json();
            } else {
                console.log(response);
                alert( 'Something went wrong. Please contact support.' );
                return false;
            }
        });
    },
    deleteLink(id) {
        return fetch(`${linkEndpoint}/${id}`, {
            method: 'DELETE',
            headers: {
                'X-WP-Nonce': eafl_admin.api_nonce,
                'Accept': 'application/json',
                'Content-Type': 'application/json',
            },
            credentials: 'same-origin',
        });
    },
    resetClicks(id) {
        return fetch(`${manageEndpoint}/clicks/${id}`, {
            method: 'DELETE',
            headers: {
                'X-WP-Nonce': eafl_admin.api_nonce,
                'Accept': 'application/json',
                'Content-Type': 'application/json',
            },
            credentials: 'same-origin',
        });
    },
    getCategories(args) {
        if ( ! gettingCategories ) {
            return this.getCategoriesDebounced(args);
        } else {
            gettingCategoriesNextArgs = args;
            return new Promise(r => r(false));
        }
    },
    getCategoriesDebounced(args) {
        gettingCategories = true;

        return fetch(`${manageEndpoint}/categories`, {
            method: 'POST',
            headers: {
                'X-WP-Nonce': eafl_admin.api_nonce,
                'Accept': 'application/json',
                'Content-Type': 'application/json',
            },
            credentials: 'same-origin',
            body: JSON.stringify(args),
        }).then(response => {
            return response.json().then(json => {
                // Check if another request is queued.
                if ( gettingCategoriesNextArgs ) {
                    const newArgs = gettingCategoriesNextArgs;
                    gettingCategoriesNextArgs = false;

                    return this.getCategoriesDebounced(newArgs);
                } else {
                    // Return this request.
                    gettingCategories = false;
                    return response.ok ? json : false;
                }
            });
        });
    },
    getCategory(id) {
        return fetch(`${categoryEndpoint}/${id}`, {
            method: 'GET',
            headers: {
                'X-WP-Nonce': eafl_admin.api_nonce,
                'Accept': 'application/json',
                'Content-Type': 'application/json',
            },
            credentials: 'same-origin',
        }).then(response => {
            if ( ! response.ok ) {
                return false;
            } else {
                return response.json().then(json => json);
            }
        });
    },
    createCategory(name) {
        const data = {
            name,
        };

        return fetch(`${categoryEndpoint}`, {
            method: 'POST',
            headers: {
                'X-WP-Nonce': eafl_admin.api_nonce,
                'Accept': 'application/json',
                'Content-Type': 'application/json',
            },
            credentials: 'same-origin',
            body: JSON.stringify(data),
        }).then(response => {
            if ( ! response.ok ) {
                return false;
            } else {
                return response.json().then(json => json);
            }
        });
    },
    deleteCategory(id) {
        return fetch(`${categoryEndpoint}/${id}?force=true`, {
            method: 'DELETE',
            headers: {
                'X-WP-Nonce': eafl_admin.api_nonce,
                'Accept': 'application/json',
                'Content-Type': 'application/json',
            },
            credentials: 'same-origin',
        });
    },
    renameCategory(id, name) {
        const data = {
            name,
        };

        return fetch(`${categoryEndpoint}/${id}`, {
            method: 'POST',
            headers: {
                'X-WP-Nonce': eafl_admin.api_nonce,
                'Accept': 'application/json',
                'Content-Type': 'application/json',
            },
            credentials: 'same-origin',
            body: JSON.stringify(data),
        });
    },
    mergeCategory(oldId, newId) {
        const data = {
            oldId,
            newId,
        };

        return fetch(`${manageEndpoint}/categories/merge`, {
            method: 'POST',
            headers: {
                'X-WP-Nonce': eafl_admin.api_nonce,
                'Accept': 'application/json',
                'Content-Type': 'application/json',
            },
            credentials: 'same-origin',
            body: JSON.stringify(data), 
        });
    },
    bulkEdit(ids, action) {
        const data = {
            ids,
            action,
        };

        return fetch(`${manageEndpoint}/links/bulk`, {
            method: 'POST',
            headers: {
                'X-WP-Nonce': eafl_admin.api_nonce,
                'Accept': 'application/json',
                'Content-Type': 'application/json',
            },
            credentials: 'same-origin',
            body: JSON.stringify(data), 
        });
    },
};
