import React, { Component, Fragment } from 'react';
import ReactTable from 'react-table';
import 'react-table/react-table.css';

import '../../../css/admin/modal/insert.scss';
import '../../../css/admin/shared/table.scss';

import Api from '../../shared/Api';
import Columns from './Columns';
import Header from '../general/Header';

export default class Insert extends Component {
    constructor(props) {
        super(props);

        this.state = {
            data: [],
            pages: null,
            loading: true,
            columns: Columns.getColumns( this ),
            insertCallback: props.args.hasOwnProperty( 'insertCallback' ) ? props.args.insertCallback : false,
            selectedText: props.args.hasOwnProperty( 'selectedText' ) ? props.args.selectedText : false,
        }

        // Bind functions.
        this.refreshData = this.refreshData.bind(this);
        this.fetchData = this.fetchData.bind(this);
        this.insertLink = this.insertLink.bind(this);
    }

    refreshData() {
        this.refReactTable.fireFetchData();
    }

    fetchData(state, instance) {
        this.setState({ loading: true });

        Api.getLinks({
            pageSize: state.pageSize,
            page: state.page,
            sorted: state.sorted,
            filtered: state.filtered,
        }).then(data => {
            if ( data ) {
                let newState = {
                    data: data.links,
                    pages: data.pages,
                    loading: false,
                };

                this.setState(newState);
            }
        });
    }

    insertLink( link, text ) {
        if ( 'function' === typeof this.state.insertCallback ) {
            this.state.insertCallback( link, text );
        }

        this.props.maybeCloseModal();
    }

    render() {
        const { columns, data, pages, loading } = this.state;

        return (
            <Fragment>
                <Header
                    onCloseModal={ this.props.maybeCloseModal }
                >
                    <button
                        className="button button-primary"
                        onClick={() => {
                            this.props.maybeCloseModal(() => {
                                const defaults = this.state.selectedText ? { text: [this.state.selectedText] } : {};

                                EAFL_Modal.open('create', {
                                    link: defaults,
                                    saveCallback: (link) => {
                                        const text = this.state.selectedText ? this.state.selectedText : link.text[0];
                                        this.insertLink( link, text );
                                    }
                                });
                            });
                        }}
                    >{ eafl_admin_manage_modal.text.modal.insert_create }</button>{ eafl_admin_manage_modal.text.modal.insert_link_header }
                </Header>
                <div className="eafl-admin-modal-content">
                    <ReactTable
                        ref={(refReactTable) => {this.refReactTable = refReactTable;}}
                        manual
                        columns={columns}
                        data={data}
                        pages={pages}
                        loading={loading}
                        onFetchData={this.fetchData}
                        defaultPageSize={25}
                        defaultSorted={[{
                            id: "id",
                            desc: true
                        }]}
                        filterable
                        resizable={false}
                        className="eafl-admin-modal-table eafl-admin-table -highlight"
                    />
                </div>
            </Fragment>
        );
    }
}