import React from 'react';
import he from 'he';
 
import CopyToClipboardIcon from '../../shared/CopyToClipboardIcon';
import Icon from '../../shared/Icon';

export default {
    selects: [],
    getColumns( links ) {
        let categories = eafl_admin_manage_modal.categories.map(cat => { return {id: cat.term_id, label: `${cat.name} (${cat.count})` } } );
        categories.sort((a,b) => a.label.localeCompare(b.label));

        let columns = [{
            Header: eafl_admin_manage_modal.text.manage.links_date,
            id: 'date',
            accessor: 'date',
            width: 90,
            Cell: row => {
                const parts = row.value.split(' ');
                return (
                    <div>{ parts[0] }</div>
                )
            },
        },{
            Header: eafl_admin_manage_modal.text.manage.links_categories,
            id: 'categories',
            accessor: 'categories',
            sortable: false,
            Filter: ({ filter, onChange }) => (
                <select
                    onChange={event => onChange(event.target.value)}
                    style={{ width: '100%', fontSize: '1em' }}
                    value={filter ? filter.value : 'all'}
                >
                    <optgroup label={ eafl_admin_manage_modal.text.manage.links_categories_general }>
                        <option value="all">{ eafl_admin_manage_modal.text.manage.links_categories_all }</option>
                        <option value="none">{ eafl_admin_manage_modal.text.manage.links_categories_none }</option>
                        <option value="any">{ eafl_admin_manage_modal.text.manage.links_categories_any }</option>
                    </optgroup>
                    <optgroup label={ eafl_admin_manage_modal.text.manage.links_categories_terms }>
                        {
                            categories.map((term, index) => (
                                <option value={term.id} key={index}>{ he.decode(term.label) }</option>
                            ))
                        }
                    </optgroup>
                </select>
            ),
            Cell: row => {
                const names = row.value.map(t => t.name);
    
                return (
                    <div>{ he.decode( names.join(', ') ) }</div>
                )
            },
            width: 200,
        },{
            Header: eafl_admin_manage_modal.text.manage.links_name,
            id: 'name',
            accessor: 'name',
            width: 250,
        },{
            Header: eafl_admin_manage_modal.text.manage.links_text,
            id: 'text',
            accessor: 'text',
            width: 250,
            Cell: row => {
                const insertLinkText = (index) => {
                    let text;

                    if ( 'custom' === index ) {
                        text = prompt( `${eafl_admin_manage_modal.text.modal.insert_link_text} ${row.original.name}` );
                    } else if ( 'selected' === index ) {
                        text = links.state.selectedText;
                    } else {
                        text = row.value[ index ];
                    }

                    if ( null !== text ) {
                        links.insertLink( row.original, text );
                    }
                };

                return (
                    <div className="eafl-admin-table-insert-container">
                        <button
                            className="button button-primary eafl-admin-table-insert-button"
                            onClick={() => { insertLinkText( this.selects[ row.original.id ].value ); }}
                        >
                            <Icon
                                type="link"
                                title={ eafl_admin_manage_modal.text.modal.insert_link }
                            />
                        </button>
                        <select
                            ref={(ref) => { this.selects[ row.original.id ] = ref; } }
                            onChange={event => { insertLinkText( event.target.value ); }}
                        >
                            {
                                links.state.selectedText
                                ?
                                <option value="selected">{ links.state.selectedText }</option>
                                :
                                null
                            }
                            {
                                row.value.map((text, index) => (
                                    <option value={index} key={index}>{ text }</option>
                                ))
                            }
                            <option value="custom">{ eafl_admin_manage_modal.text.modal.insert_link_custom }</option>
                        </select>
                    </div>
                )
            },
        },{
            Header: eafl_admin_manage_modal.text.manage.links_shortlink,
            id: 'shortlink',
            accessor: 'shortlink',
            width: 400,
            Cell: row => {
                const cloak = eafl_admin_manage_modal.options.cloak.find((option) => option.value === row.original.cloak );
                if ( cloak && 'no' === cloak.actual ) {
                    return null;
                }

                return (
                    <div className="eafl-admin-table-links-shortlink-container">
                        <CopyToClipboardIcon text={row.value} />
                        <a href={row.value} target="_blank" className="eafl-admin-table-links-shortlink">{row.value}</a>
                    </div>
                )
            },
        },{
            Header: eafl_admin_manage_modal.text.manage.links_url,
            id: 'url',
            accessor: 'url',
            width: 400,
            Cell: row => {
                if ( ! row.value ) {
                    return null;
                }

                return (
                    <div className="eafl-admin-table-links-url-container">
                        <CopyToClipboardIcon text={row.value} />
                        <a href={row.value} target="_blank" className="eafl-admin-table-links-url">{row.value}</a>
                    </div>
                )
            },
        }];

        return columns;
    }
};