import React from 'react';
 
const Totals = (props) => {
    if ( !props.total ) {
        return null;
    }

    const isFiltered = false !== props.filtered && props.filtered != props.total;

    return (
        <div className="eafl-admin-table-totals">
            {
                isFiltered
                ?
                `Showing ${ Number(props.filtered).toLocaleString() } filtered of ${ Number(props.total).toLocaleString() } total`
                :
                `Showing ${ Number(props.total).toLocaleString() } total`
            }
        </div>
    );
}
export default Totals;