import React from 'react';
import he from 'he';
 
import Api from '../../shared//Api';
import Icon from '../../shared/Icon';

export default {
    getColumns(refreshData) {
        let columns = [{
            Header: eafl_admin_manage_modal.text.manage.table_sort,
            id: 'actions',
            headerClassName: 'eafl-admin-table-help-text',
            sortable: false,
            width: 100,
            Filter: () => (
                <div>
                    { eafl_admin_manage_modal.text.manage.table_filter }
                </div>
            ),
            Cell: row => (
                <div className="eafl-admin-manage-actions">
                    <Icon
                        type="edit"
                        title={ eafl_admin_manage_modal.text.manage.category_rename }
                        onClick={() => {
                            let newName = prompt( `What do you want to rename the "${row.original.name}" category to?`, row.original.name );
                            if( newName && newName.trim() ) {
                                Api.renameCategory(row.original.term_id, newName).then(() => refreshData());
                            }
                        }}
                    />
                    <Icon
                        type="merge"
                        title={ eafl_admin_manage_modal.text.manage.category_merge }
                        onClick={() => {
                            let newId = prompt( `What is the ID of the category you want the merge "${row.original.name}" category into?` );
                            if( newId && newId != row.original.term_id && newId.trim() ) {
                                Api.getCategory(newId).then(newCategory => {
                                    if ( newCategory ) {
                                        if ( confirm( `Are you sure you want to merge "${row.original.name}" into the "${newCategory.name}" category?` ) ) {
                                            Api.mergeCategory(row.original.term_id, newId).then(() => refreshData());
                                        }
                                    } else {
                                        alert( 'We could not find a category with that ID.' );
                                    }
                                });
                            }
                        }}
                    />
                    <Icon
                        type="delete"
                        title={ eafl_admin_manage_modal.text.manage.category_delete }
                        onClick={() => {
                            if ( confirm( `Are you sure you want to delete the "${row.original.name}" category?` ) ) {
                                Api.deleteCategory(row.original.term_id).then(() => refreshData());
                            }
                        }}
                    />
                </div>
            ),
        },{
            Header: eafl_admin_manage_modal.text.manage.category_id,
            id: 'id',
            accessor: 'term_id',
            width: 65,
        },{
            Header: eafl_admin_manage_modal.text.manage.category_name,
            id: 'name',
            accessor: 'name',
            Cell: row => he.decode(row.value),
        },{
            Header: eafl_admin_manage_modal.text.manage.category_links,
            id: 'count',
            accessor: 'count',
            filterable: false,
            width: 65,
        }];

        return columns;
    }
};