<?php
/**
 * Handle the assets for manage and modal.
 *
 * @link       https://bootstrapped.ventures
 * @since      3.0.0
 *
 * @package    Easy_Affiliate_Links
 * @subpackage Easy_Affiliate_Links/includes/admin/manage
 */

/**
 * Handle the assets for manage and modal.
 *
 * @since      3.0.0
 * @package    Easy_Affiliate_Links
 * @subpackage Easy_Affiliate_Links/includes/admin/manage
 * @author     Brecht Vandersmissen <brecht@bootstrapped.ventures>
 */
class EAFL_Manage_Modal {

	/**
	 * Register actions and filters.
	 *
	 * @since    3.0.0
	 */
	public static function init() {
		add_action( 'admin_menu', array( __CLASS__, 'add_manage_page' ), 11 );
		add_action( 'admin_footer', array( __CLASS__, 'add_modal_content' ) );

		add_action( 'admin_enqueue_scripts', array( __CLASS__, 'enqueue' ) );
	}

	/**
	 * Add the manage submenu to the EAFL menu.
	 *
	 * @since    3.0.0
	 */
	public static function add_manage_page() {
		add_submenu_page( 'easyaffiliatelinks', __( 'Manage', 'easy-affiliate-links' ), __( 'Manage', 'easy-affiliate-links' ), 'manage_options', 'easyaffiliatelinks', array( __CLASS__, 'manage_page_template' ) );
	}

	/**
	 * Get the template for this submenu.
	 *
	 * @since    3.0.0
	 */
	public static function manage_page_template() {
		echo '<div class="wrap"><div id="eafl-admin-manage">Loading...</div></div>';
	}

	/**
	 * Add modal template to edit screen.
	 *
	 * @since    3.0.0
	 */
	public static function add_modal_content() {
		echo '<div id="eafl-admin-modal"></div>';
	}

	/**
	 * Enqueue stylesheets and scripts.
	 *
	 * @since    3.0.0
	 */
	public static function enqueue() {
		wp_enqueue_style( 'eafl-admin-manage-modal', EAFL_URL . 'dist/admin-manage-modal.css', array(), EAFL_VERSION, 'all' );
		wp_enqueue_script( 'eafl-admin-manage-modal', EAFL_URL . 'dist/admin-manage-modal.js', array( 'eafl-admin' ), EAFL_VERSION, true );

		wp_localize_script( 'eafl-admin-manage-modal', 'eafl_admin_manage_modal', array(
			'categories' => array_values( self::get_link_categories() ),
			'link' => self::get_new_link(),
			'link_preview' => site_url( '/' . EAFL_Settings::get( 'shortlink_slug' ) . '/' ),
			'options' => array(
				'cloak' => self::get_cloak_options(),
				'target' => self::get_target_options(),
				'redirect_type' => self::get_redirect_type_options(),
				'nofollow' => self::get_nofollow_options(),
			),
			'text' => array(
				'manage' => array(
					'table_sort' => __( 'Sort:', 'easy-affiliate-links' ),
					'table_filter' => __( 'Filter:', 'easy-affiliate-links' ),
					'categories' => __( 'Categories', 'easy-affiliate-links' ),
					'category_rename' => __( 'Rename Category', 'easy-affiliate-links' ),
					'category_merge' => __( 'Merge into another category', 'easy-affiliate-links' ),
					'category_delete' => __( 'Delete Category', 'easy-affiliate-links' ),
					'category_id' => __( 'ID', 'easy-affiliate-links' ),
					'category_name' => __( 'Name', 'easy-affiliate-links' ),
					'category_links' => __( '# Links', 'easy-affiliate-links' ),
					'category_create' => __( 'What do you want to be the name of this new category?', 'easy-affiliate-links' ),
					'category_create_problem' => __( 'We were not able to create this category. Make sure it does not exist yet.', 'easy-affiliate-links' ),
					'columns_show_hide' => __( 'Show/Hide Columns:', 'easy-affiliate-links' ),
					'links' => __( 'Links', 'easy-affiliate-links' ),
					'links_bulk_edit' => __( 'Bulk Edit', 'easy-affiliate-links' ),
					'links_id' => __( 'ID', 'easy-affiliate-links' ),
					'links_date' => __( 'Date', 'easy-affiliate-links' ),
					'links_categories' => __( 'Categories', 'easy-affiliate-links' ),
					'links_categories_general' => __( 'General', 'easy-affiliate-links' ),
					'links_categories_all' => __( 'All Categories', 'easy-affiliate-links' ),
					'links_categories_none' => __( 'No Categories', 'easy-affiliate-links' ),
					'links_categories_any' => __( 'Any Categories', 'easy-affiliate-links' ),
					'links_categories_terms' => __( 'Terms', 'easy-affiliate-links' ),
					'links_name' => __( 'Name', 'easy-affiliate-links' ),
					'links_description' => __( 'Description', 'easy-affiliate-links' ),
					'links_clicks' => __( 'Clicks', 'easy-affiliate-links' ),
					'links_clicks_delete' => __( 'Reset Clicks', 'easy-affiliate-links' ),
					'links_clicks_month' => __( 'This month', 'easy-affiliate-links' ),
					'links_clicks_lifetime' => __( 'Lifetime', 'easy-affiliate-links' ),
					'links_text' => __( 'Text', 'easy-affiliate-links' ),
					'links_cloaking' => __( 'Cloaking', 'easy-affiliate-links' ),
					'links_cloaking_any' => __( 'Any Cloaking', 'easy-affiliate-links' ),
					'links_target' => __( 'Target', 'easy-affiliate-links' ),
					'links_target_any' => __( 'Any Target', 'easy-affiliate-links' ),
					'links_redirect_type' => __( 'Redirect Type', 'easy-affiliate-links' ),
					'links_redirect_type_any' => __( 'Any Redirect Type', 'easy-affiliate-links' ),
					'links_nofollow' => __( 'Nofollow', 'easy-affiliate-links' ),
					'links_nofollow_any' => __( 'Any Nofollow', 'easy-affiliate-links' ),
					'links_shortlink' => __( 'Shortlink', 'easy-affiliate-links' ),
					'links_url' => __( 'URL', 'easy-affiliate-links' ),
					'links_edit' => __( 'Edit Link', 'easy-affiliate-links' ),
					'links_delete' => __( 'Delete Link', 'easy-affiliate-links' ),
					'links_create' => __( 'Create Link', 'easy-affiliate-links' ),
					'clipboard_copy' => __( 'Copy to clipboard', 'easy-affiliate-links' ),
					'clipboard_copied' => __( 'Copied!', 'easy-affiliate-links' ),
				),
				'modal' => array(
					'close' => __( 'Close', 'easy-affiliate-links' ),
					'confirm_close' => __( 'Are you sure you want to close without saving changes?', 'easy-affiliate-links' ),
					'cancel' => __( 'Cancel Changes', 'easy-affiliate-links' ),
					'save' => __( 'Save Changes', 'easy-affiliate-links' ),
					'bulk_add_categories' => __( 'Add Categories', 'easy-affiliate-links' ),
					'bulk_remove_categories' => __( 'Remove Categories', 'easy-affiliate-links' ),
					'bulk_change_cloaking' => __( 'Change Cloaking', 'easy-affiliate-links' ),
					'bulk_change_target' => __( 'Change Target', 'easy-affiliate-links' ),
					'bulk_change_redirect_type' => __( 'Change Redirect Type', 'easy-affiliate-links' ),
					'bulk_change_nofollow' => __( 'Change Nofollow', 'easy-affiliate-links' ),
					'bulk_reset_clicks' => __( 'Reset Clicks', 'easy-affiliate-links' ),
					'bulk_delete_links' => __( 'Delete Links', 'easy-affiliate-links' ),
					'bulk_select_action' => __( 'Select an action to perform:', 'easy-affiliate-links' ),
					'bulk_select_options' => __( 'Action options:', 'easy-affiliate-links' ),
					'bulk_edit_links' => __( 'Bulk Edit Links', 'easy-affiliate-links' ),
					'insert_create' => __( 'Create new Affiliate Link', 'easy-affiliate-links' ),
					'insert_link_header' => __( 'or insert an existing link', 'easy-affiliate-links' ),
					'insert_link' => __( 'Insert Link', 'easy-affiliate-links' ),
					'insert_link_text' => __( 'Link text to use for:', 'easy-affiliate-links' ),
					'insert_link_custom' => __( '...or use a custom text', 'easy-affiliate-links' ),
					'text_header' => __( 'or change link text', 'easy-affiliate-links' ),
					'text_label' => __( 'Link text', 'easy-affiliate-links' ),
					'text_change' => __( 'Change Text', 'easy-affiliate-links' ),
					'link_edit' => __( 'Edit Affiliate Link', 'easy-affiliate-links' ),
					'link_create' => __( 'Create Link', 'easy-affiliate-links' ),
					'link_create_header' => __( 'Create new Affiliate Link', 'easy-affiliate-links' ),
					'link_organization' => __( 'Organization', 'easy-affiliate-links' ),
					'link_name' => __( 'Name', 'easy-affiliate-links' ),
					'link_description' => __( 'Description', 'easy-affiliate-links' ),
					'link_categories' => __( 'Categories', 'easy-affiliate-links' ),
					'link_details' => __( 'Details', 'easy-affiliate-links' ),
					'link_url' => __( 'Link Destination URL', 'easy-affiliate-links' ),
					'link_cloaking' => __( 'Link Cloaking', 'easy-affiliate-links' ),
					'link_slug' => __( 'Shortlink Slug', 'easy-affiliate-links' ),
					'link_shortcode' => __( 'Shortcode', 'easy-affiliate-links' ),
					'link_text' => __( 'Default Link Text', 'easy-affiliate-links' ),
					'link_variant' => __( 'Add variant', 'easy-affiliate-links' ),
					'link_target' => __( 'Target', 'easy-affiliate-links' ),
					'link_redirect_type' => __( 'Redirect Type', 'easy-affiliate-links' ),
					'link_nofollow' => __( 'Nofollow', 'easy-affiliate-links' ),
				),
			)
		) );
	}

	/**
	 * Get link categories.
	 *
	 * @since    3.0.0
	 */
	public static function get_link_categories() {
		return get_terms( array(
			'taxonomy' => 'eafl_category',
			'hide_empty' => false,
			'count' => true,
		) );
	}

	/**
	 * Get new link.
	 *
	 * @since    3.0.0
	 */
	public static function get_new_link() {
		return array(
			'name' => '',
			'decription' => '',
			'categories' => array(),
			'text' => array( '' ),
			'slug' => '',
			'cloak' => 'default',
			'target' => 'default',
			'redirect_type' => 'default',
			'nofollow' => 'default',
		);
	}

	/**
	 * Get all cloak options.
	 *
	 * @since    3.0.0
	 */
	public static function get_cloak_options() {
		$labels = array(
			'yes' => __( 'Cloak affiliate link', 'easy-affiliate-links' ),
			'no' => __( 'Do not cloak affiliate link', 'easy-affiliate-links' ),
		);

		$default = EAFL_Settings::get( 'default_cloak' );

		$options = array(
			array(
				'value' => 'default',
				'label' => __( 'Use Default', 'easy-affiliate-links' ) . ' (' . $labels[ $default ] . ')',
				'actual' => $default,
			),
		);

		foreach ( $labels as $value => $label ) {
			$options[] = array(
				'value' => $value,
				'label' => $label,
				'actual' => $value,
			);
		}

		return $options;
	}

	/**
	 * Get all target options.
	 *
	 * @since    3.0.0
	 */
	public static function get_target_options() {
		$labels = array(
			'_self' => __( 'Open in same tab', 'easy-affiliate-links' ),
			'_blank' => __( 'Open in new tab', 'easy-affiliate-links' ),
		);

		$default = EAFL_Settings::get( 'default_target' );

		$options = array(
			array(
				'value' => 'default',
				'label' => __( 'Use Default', 'easy-affiliate-links' ) . ' (' . $labels[ $default ] . ')',
				'actual' => $default,
			),
		);

		foreach ( $labels as $value => $label ) {
			$options[] = array(
				'value' => $value,
				'label' => $label,
				'actual' => $value,
			);
		}

		return $options;
	}

	/**
	 * Get all redirect type options.
	 *
	 * @since    3.0.0
	 */
	public static function get_redirect_type_options() {
		$labels = array(
			'301' => __( '301 Permanent', 'easy-affiliate-links' ),
			'302' => __( '302 Temporary', 'easy-affiliate-links' ),
			'307' => __( '307 Temporary', 'easy-affiliate-links' ),
		);

		$default = EAFL_Settings::get( 'default_redirect_type' );

		$options = array(
			array(
				'value' => 'default',
				'label' => __( 'Use Default', 'easy-affiliate-links' ) . ' (' . $labels[ $default ] . ')',
				'actual' => $default,
			),
		);

		foreach ( $labels as $value => $label ) {
			$options[] = array(
				'value' => $value,
				'label' => $label,
				'actual' => $value,
			);
		}

		return $options;
	}

	/**
	 * Get all nofollow options.
	 *
	 * @since    3.0.0
	 */
	public static function get_nofollow_options() {
		$labels = array(
			'follow' => __( 'Do not add nofollow attribute', 'easy-affiliate-links' ),
			'nofollow' => __( 'Add nofollow attribute', 'easy-affiliate-links' ),
		);

		$default = EAFL_Settings::get( 'default_nofollow' );

		$options = array(
			array(
				'value' => 'default',
				'label' => __( 'Use Default', 'easy-affiliate-links' ) . ' (' . $labels[ $default ] . ')',
				'actual' => $default,
			),
		);

		foreach ( $labels as $value => $label ) {
			$options[] = array(
				'value' => $value,
				'label' => $label,
				'actual' => $value,
			);
		}

		return $options;
	}
}

EAFL_Manage_Modal::init();
