<?php
/**
 * Extensions section.
 *
 * @package Meta Box
 */

?>
<div id="extensions" class="gt-tab-pane">
	<p class="about-description">
		<?php esc_html_e( 'Extend custom fields in WordPress well beyond what others would ever consider ordinary! Save over 70% with our extensions bundles.', 'meta-box' ); ?> <a target="_blank" href="https://metabox.io/pricing/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'View Bundles', 'meta-box' ); ?> &rarr;</a>
	</p>
	<div class="extensions wp-clearfix">
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M736 1440q0 12-10 24l-319 319q-10 9-23 9-12 0-23-9l-320-320q-15-16-7-35 8-20 30-20h192v-1376q0-14 9-23t23-9h192q14 0 23 9t9 23v1376h192q14 0 23 9t9 23zm1056 128v192q0 14-9 23t-23 9h-832q-14 0-23-9t-9-23v-192q0-14 9-23t23-9h832q14 0 23 9t9 23zm-192-512v192q0 14-9 23t-23 9h-640q-14 0-23-9t-9-23v-192q0-14 9-23t23-9h640q14 0 23 9t9 23zm-192-512v192q0 14-9 23t-23 9h-448q-14 0-23-9t-9-23v-192q0-14 9-23t23-9h448q14 0 23 9t9 23zm-192-512v192q0 14-9 23t-23 9h-256q-14 0-23-9t-9-23v-192q0-14 9-23t23-9h256q14 0 23 9t9 23z"/></svg>
				<div class="extension-info">
					<h3>Meta Box Builder</h3>
					<p><?php esc_html_e( 'Drag and drop your custom fields into place without a single line of code.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/meta-box-builder/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Learn More', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1596 476q14 14 28 36h-472v-472q22 14 36 28zm-476 164h544v1056q0 40-28 68t-68 28h-1344q-40 0-68-28t-28-68v-1600q0-40 28-68t68-28h800v544q0 40 28 68t68 28zm160 736v-64q0-14-9-23t-23-9h-704q-14 0-23 9t-9 23v64q0 14 9 23t23 9h704q14 0 23-9t9-23zm0-256v-64q0-14-9-23t-23-9h-704q-14 0-23 9t-9 23v64q0 14 9 23t23 9h704q14 0 23-9t9-23zm0-256v-64q0-14-9-23t-23-9h-704q-14 0-23 9t-9 23v64q0 14 9 23t23 9h704q14 0 23-9t9-23z" /></svg>
				<div class="extension-info">
					<h3>MB Custom Post Type</h3>
					<p><?php esc_html_e( 'Create and manage custom post types easily in WordPress with an easy-to-use interface.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/custom-post-type/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Free Download', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M512 1248v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm0-512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm1280 512v192q0 40-28 68t-68 28h-960q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h960q40 0 68 28t28 68zm-1280-1024v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm1280 512v192q0 40-28 68t-68 28h-960q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h960q40 0 68 28t28 68zm0-512v192q0 40-28 68t-68 28h-960q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h960q40 0 68 28t28 68z" /></svg>
				<div class="extension-info">
					<h3>Meta Box Group</h3>
					<p><?php esc_html_e( 'Create repeatable groups of custom fields for better appearance and structure.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/meta-box-group/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Learn More', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1152 896q0-106-75-181t-181-75-181 75-75 181 75 181 181 75 181-75 75-181zm512-109v222q0 12-8 23t-20 13l-185 28q-19 54-39 91 35 50 107 138 10 12 10 25t-9 23q-27 37-99 108t-94 71q-12 0-26-9l-138-108q-44 23-91 38-16 136-29 186-7 28-36 28h-222q-14 0-24.5-8.5t-11.5-21.5l-28-184q-49-16-90-37l-141 107q-10 9-25 9-14 0-25-11-126-114-165-168-7-10-7-23 0-12 8-23 15-21 51-66.5t54-70.5q-27-50-41-99l-183-27q-13-2-21-12.5t-8-23.5v-222q0-12 8-23t19-13l186-28q14-46 39-92-40-57-107-138-10-12-10-24 0-10 9-23 26-36 98.5-107.5t94.5-71.5q13 0 26 10l138 107q44-23 91-38 16-136 29-186 7-28 36-28h222q14 0 24.5 8.5t11.5 21.5l28 184q49 16 90 37l142-107q9-9 24-9 13 0 25 10 129 119 165 170 7 8 7 22 0 12-8 23-15 21-51 66.5t-54 70.5q26 50 41 98l183 28q13 2 21 12.5t8 23.5z" /></svg>
				<div class="extension-info">
					<h3>MB Settings Page</h3>
					<p><?php esc_html_e( 'Create a powerful settings page for your theme, plugin or website.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/mb-settings-page/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Learn More', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1792 1184v192q0 13-9.5 22.5t-22.5 9.5h-1376v192q0 13-9.5 22.5t-22.5 9.5q-12 0-24-10l-319-320q-9-9-9-22 0-14 9-23l320-320q9-9 23-9 13 0 22.5 9.5t9.5 22.5v192h1376q13 0 22.5 9.5t9.5 22.5zm0-544q0 14-9 23l-320 320q-9 9-23 9-13 0-22.5-9.5t-9.5-22.5v-192h-1376q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1376v-192q0-14 9-23t23-9q12 0 24 10l319 319q9 9 9 23z" /></svg>
				<div class="extension-info">
					<h3>Meta Box Conditional Logic</h3>
					<p><?php esc_html_e( 'Control the visibility of meta boxes and fields or even HTML elements with ease.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/meta-box-conditional-logic/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Learn More', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1703 478q40 57 18 129l-275 906q-19 64-76.5 107.5t-122.5 43.5h-923q-77 0-148.5-53.5t-99.5-131.5q-24-67-2-127 0-4 3-27t4-37q1-8-3-21.5t-3-19.5q2-11 8-21t16.5-23.5 16.5-23.5q23-38 45-91.5t30-91.5q3-10 .5-30t-.5-28q3-11 17-28t17-23q21-36 42-92t25-90q1-9-2.5-32t.5-28q4-13 22-30.5t22-22.5q19-26 42.5-84.5t27.5-96.5q1-8-3-25.5t-2-26.5q2-8 9-18t18-23 17-21q8-12 16.5-30.5t15-35 16-36 19.5-32 26.5-23.5 36-11.5 47.5 5.5l-1 3q38-9 51-9h761q74 0 114 56t18 130l-274 906q-36 119-71.5 153.5t-128.5 34.5h-869q-27 0-38 15-11 16-1 43 24 70 144 70h923q29 0 56-15.5t35-41.5l300-987q7-22 5-57 38 15 59 43zm-1064 2q-4 13 2 22.5t20 9.5h608q13 0 25.5-9.5t16.5-22.5l21-64q4-13-2-22.5t-20-9.5h-608q-13 0-25.5 9.5t-16.5 22.5zm-83 256q-4 13 2 22.5t20 9.5h608q13 0 25.5-9.5t16.5-22.5l21-64q4-13-2-22.5t-20-9.5h-608q-13 0-25.5 9.5t-16.5 22.5z" /></svg>
				<div class="extension-info">
					<h3>MB Term Meta</h3>
					<p><?php esc_html_e( 'Easily add custom fields to categories, tags or any custom taxonomy.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/mb-term-meta/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Learn More', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1536 1399q0 109-62.5 187t-150.5 78h-854q-88 0-150.5-78t-62.5-187q0-85 8.5-160.5t31.5-152 58.5-131 94-89 134.5-34.5q131 128 313 128t313-128q76 0 134.5 34.5t94 89 58.5 131 31.5 152 8.5 160.5zm-256-887q0 159-112.5 271.5t-271.5 112.5-271.5-112.5-112.5-271.5 112.5-271.5 271.5-112.5 271.5 112.5 112.5 271.5z" /></svg>
				<div class="extension-info">
					<h3>MB User Meta</h3>
					<p><?php esc_html_e( 'Add custom fields to user profile (user meta) quickly with simple syntax.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/mb-user-meta/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Learn More', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 2048 1792" xmlns="http://www.w3.org/2000/svg"><path d="M657 896q-162 5-265 128h-134q-82 0-138-40.5t-56-118.5q0-353 124-353 6 0 43.5 21t97.5 42.5 119 21.5q67 0 133-23-5 37-5 66 0 139 81 256zm1071 637q0 120-73 189.5t-194 69.5h-874q-121 0-194-69.5t-73-189.5q0-53 3.5-103.5t14-109 26.5-108.5 43-97.5 62-81 85.5-53.5 111.5-20q10 0 43 21.5t73 48 107 48 135 21.5 135-21.5 107-48 73-48 43-21.5q61 0 111.5 20t85.5 53.5 62 81 43 97.5 26.5 108.5 14 109 3.5 103.5zm-1024-1277q0 106-75 181t-181 75-181-75-75-181 75-181 181-75 181 75 75 181zm704 384q0 159-112.5 271.5t-271.5 112.5-271.5-112.5-112.5-271.5 112.5-271.5 271.5-112.5 271.5 112.5 112.5 271.5zm576 225q0 78-56 118.5t-138 40.5h-134q-103-123-265-128 81-117 81-256 0-29-5-66 66 23 133 23 59 0 119-21.5t97.5-42.5 43.5-21q124 0 124 353zm-128-609q0 106-75 181t-181 75-181-75-75-181 75-181 181-75 181 75 75 181z" /></svg>
				<div class="extension-info">
					<h3>MB User Profile</h3>
					<p><?php esc_html_e( 'Create register, login and edit user profile forms in the frontend. Embed everywhere with shortcodes.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/mb-user-profile/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Learn More', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M381 1620q0 80-54.5 126t-135.5 46q-106 0-172-66l57-88q49 45 106 45 29 0 50.5-14.5t21.5-42.5q0-64-105-56l-26-56q8-10 32.5-43.5t42.5-54 37-38.5v-1q-16 0-48.5 1t-48.5 1v53h-106v-152h333v88l-95 115q51 12 81 49t30 88zm2-627v159h-362q-6-36-6-54 0-51 23.5-93t56.5-68 66-47.5 56.5-43.5 23.5-45q0-25-14.5-38.5t-39.5-13.5q-46 0-81 58l-85-59q24-51 71.5-79.5t105.5-28.5q73 0 123 41.5t50 112.5q0 50-34 91.5t-75 64.5-75.5 50.5-35.5 52.5h127v-60h105zm1409 319v192q0 13-9.5 22.5t-22.5 9.5h-1216q-13 0-22.5-9.5t-9.5-22.5v-192q0-14 9-23t23-9h1216q13 0 22.5 9.5t9.5 22.5zm-1408-899v99h-335v-99h107q0-41 .5-121.5t.5-121.5v-12h-2q-8 17-50 54l-71-76 136-127h106v404h108zm1408 387v192q0 13-9.5 22.5t-22.5 9.5h-1216q-13 0-22.5-9.5t-9.5-22.5v-192q0-14 9-23t23-9h1216q13 0 22.5 9.5t9.5 22.5zm0-512v192q0 13-9.5 22.5t-22.5 9.5h-1216q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1216q13 0 22.5 9.5t9.5 22.5z" /></svg>
				<div class="extension-info">
					<h3>MB Frontend Submission</h3>
					<p><?php esc_html_e( 'Create frontend forms for users to submit custom content. Embed everywhere with shortcode.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/mb-frontend-submission/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Learn More', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1600 1312v-704q0-40-28-68t-68-28h-704q-40 0-68-28t-28-68v-64q0-40-28-68t-68-28h-320q-40 0-68 28t-28 68v960q0 40 28 68t68 28h1216q40 0 68-28t28-68zm128-704v704q0 92-66 158t-158 66h-1216q-92 0-158-66t-66-158v-960q0-92 66-158t158-66h320q92 0 158 66t66 158v32h672q92 0 158 66t66 158z" /></svg>
				<div class="extension-info">
					<h3>Meta Box Tabs</h3>
					<p><?php esc_html_e( 'Add as many custom fields as you want and organize them into tabs.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/meta-box-tabs/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Learn More', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M576 1376v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm0-384v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm512 384v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm-512-768v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm512 384v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm512 384v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm-512-768v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm512 384v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm0-384v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm128-320v1088q0 66-47 113t-113 47h-1344q-66 0-113-47t-47-113v-1088q0-66 47-113t113-47h1344q66 0 113 47t47 113z" /></svg>
				<div class="extension-info">
					<h3>MB Custom Table</h3>
					<p><?php esc_html_e( 'Save custom fields data to custom table instead of the default meta tables. Reduce database size and increase performance.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/mb-custom-table/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Learn More', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M672 1472q0-40-28-68t-68-28-68 28-28 68 28 68 68 28 68-28 28-68zm0-1152q0-40-28-68t-68-28-68 28-28 68 28 68 68 28 68-28 28-68zm640 128q0-40-28-68t-68-28-68 28-28 68 28 68 68 28 68-28 28-68zm96 0q0 52-26 96.5t-70 69.5q-2 287-226 414-67 38-203 81-128 40-169.5 71t-41.5 100v26q44 25 70 69.5t26 96.5q0 80-56 136t-136 56-136-56-56-136q0-52 26-96.5t70-69.5v-820q-44-25-70-69.5t-26-96.5q0-80 56-136t136-56 136 56 56 136q0 52-26 96.5t-70 69.5v497q54-26 154-57 55-17 87.5-29.5t70.5-31 59-39.5 40.5-51 28-69.5 8.5-91.5q-44-25-70-69.5t-26-96.5q0-80 56-136t136-56 136 56 56 136z" /></svg>
				<div class="extension-info">
					<h3>MB Rest API</h3>
					<p><?php esc_html_e( 'Pull all meta value from posts, terms into the WP REST API responses.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/mb-rest-api/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Free Download', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1792 1184v192q0 13-9.5 22.5t-22.5 9.5h-1376v192q0 13-9.5 22.5t-22.5 9.5q-12 0-24-10l-319-320q-9-9-9-22 0-14 9-23l320-320q9-9 23-9 13 0 22.5 9.5t9.5 22.5v192h1376q13 0 22.5 9.5t9.5 22.5zm0-544q0 14-9 23l-320 320q-9 9-23 9-13 0-22.5-9.5t-9.5-22.5v-192h-1376q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1376v-192q0-14 9-23t23-9q12 0 24 10l319 319q9 9 9 23z" /></svg>
				<div class="extension-info">
					<h3>MB Relationships</h3>
					<p><?php esc_html_e( 'A lightweight WordPress plugin for creating many-to-many relationships between posts, terms and users.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/mb-relationships/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Free Download', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 2048 1792" xmlns="http://www.w3.org/2000/svg"><path d="M212 768l623 665-300-665h-323zm812 772l349-772h-698zm-486-900l204-384h-262l-288 384h346zm675 793l623-665h-323zm-530-793h682l-204-384h-274zm827 0h346l-288-384h-262zm141-486l384 512q14 18 13 41.5t-17 40.5l-960 1024q-18 20-47 20t-47-20l-960-1024q-16-17-17-40.5t13-41.5l384-512q18-26 51-26h1152q33 0 51 26z" /></svg>
				<div class="extension-info">
					<h3>Meta Box – FacetWP Integrator</h3>
					<p><?php esc_html_e( 'Integrates Meta Box and FacetWP, makes custom fields searchable and filterable in the frontend.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/meta-box-facetwp-integrator/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Free Download', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1755 453q37 38 37 90.5t-37 90.5l-401 400 150 150-160 160q-163 163-389.5 186.5t-411.5-100.5l-362 362h-181v-181l362-362q-124-185-100.5-411.5t186.5-389.5l160-160 150 150 400-401q38-37 91-37t90 37 37 90.5-37 90.5l-400 401 234 234 401-400q38-37 91-37t90 37z" /></svg>
				<div class="extension-info">
					<h3>Meta Box – Beaver Themer Integrator</h3>
					<p><?php esc_html_e( 'Select and show custom fields created by the Meta Box plugin in the Beaver Themer field connection.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/meta-box-beaver-themer-integrator/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Free Download', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1792 896q0 174-120 321.5t-326 233-450 85.5q-70 0-145-8-198 175-460 242-49 14-114 22-17 2-30.5-9t-17.5-29v-1q-3-4-.5-12t2-10 4.5-9.5l6-9 7-8.5 8-9q7-8 31-34.5t34.5-38 31-39.5 32.5-51 27-59 26-76q-157-89-247.5-220t-90.5-281q0-130 71-248.5t191-204.5 286-136.5 348-50.5q244 0 450 85.5t326 233 120 321.5z" /></svg>
				<div class="extension-info">
					<h3>MB Comment Meta</h3>
					<p><?php esc_html_e( 'Add custom fields to comments in WordPress. Support all field types and options.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/mb-comment-meta/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Free Download', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1664 256v448q0 26-19 45t-45 19h-448q-42 0-59-40-17-39 14-69l138-138q-148-137-349-137-104 0-198.5 40.5t-163.5 109.5-109.5 163.5-40.5 198.5 40.5 198.5 109.5 163.5 163.5 109.5 198.5 40.5q119 0 225-52t179-147q7-10 23-12 15 0 25 9l137 138q9 8 9.5 20.5t-7.5 22.5q-109 132-264 204.5t-327 72.5q-156 0-298-61t-245-164-164-245-61-298 61-298 164-245 245-164 298-61q147 0 284.5 55.5t244.5 156.5l130-129q29-31 70-14 39 17 39 59z" /></svg>
				<div class="extension-info">
					<h3>MB Revision</h3>
					<p><?php esc_html_e( 'Track changes of custom fields with WordPress revision. Save, compare, restore the changes easily.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/mb-revision/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Learn More', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1593 349l-640 1280q-17 35-57 35-5 0-15-2-22-5-35.5-22.5t-13.5-39.5v-576h-576q-22 0-39.5-13.5t-22.5-35.5 4-42 29-30l1280-640q13-7 29-7 27 0 45 19 15 14 18.5 34.5t-6.5 39.5z" /></svg>
				<div class="extension-info">
					<h3>Meta Box Geolocation</h3>
					<p><?php esc_html_e( 'Automatically and instantly populate location data with the power of Google Maps Geolocation API.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/meta-box-geolocation/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Learn More', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M576 1376v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm0-384v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm512 384v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm-512-768v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm512 384v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm512 384v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm-512-768v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm512 384v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm0-384v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm128-320v1088q0 66-47 113t-113 47h-1344q-66 0-113-47t-47-113v-1088q0-66 47-113t113-47h1344q66 0 113 47t47 113z" /></svg>
				<div class="extension-info">
					<h3>MB Admin Columns</h3>
					<p><?php esc_html_e( 'Display custom fields in table columns in admin screens for All Posts (types).', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/mb-admin-columns/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Learn More', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M888 1184l116-116-152-152-116 116v56h96v96h56zm440-720q-16-16-33 1l-350 350q-17 17-1 33t33-1l350-350q17-17 1-33zm80 594v190q0 119-84.5 203.5t-203.5 84.5h-832q-119 0-203.5-84.5t-84.5-203.5v-832q0-119 84.5-203.5t203.5-84.5h832q63 0 117 25 15 7 18 23 3 17-9 29l-49 49q-14 14-32 8-23-6-45-6h-832q-66 0-113 47t-47 113v832q0 66 47 113t113 47h832q66 0 113-47t47-113v-126q0-13 9-22l64-64q15-15 35-7t20 29zm-96-738l288 288-672 672h-288v-288zm444 132l-92 92-288-288 92-92q28-28 68-28t68 28l152 152q28 28 28 68t-28 68z" /></svg>
				<div class="extension-info">
					<h3>Meta Box for Yoast SEO</h3>
					<p><?php esc_html_e( 'Add content of custom fields to Yoast SEO Content Analysis to have better/correct SEO score.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/meta-box-yoast-seo/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Free Download', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M491 1536l91-91-235-235-91 91v107h128v128h107zm523-928q0-22-22-22-10 0-17 7l-542 542q-7 7-7 17 0 22 22 22 10 0 17-7l542-542q7-7 7-17zm-54-192l416 416-832 832h-416v-416zm683 96q0 53-37 90l-166 166-416-416 166-165q36-38 90-38 53 0 91 38l235 234q37 39 37 91z" /></svg>
				<div class="extension-info">
					<h3>Meta Box Text Limiter</h3>
					<p><?php esc_html_e( 'Limit the number of characters or words entered for text and textarea fields.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/meta-box-text-limiter/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Free Download', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1639 1056q0 5-1 7-64 268-268 434.5t-478 166.5q-146 0-282.5-55t-243.5-157l-129 129q-19 19-45 19t-45-19-19-45v-448q0-26 19-45t45-19h448q26 0 45 19t19 45-19 45l-137 137q71 66 161 102t187 36q134 0 250-65t186-179q11-17 53-117 8-23 30-23h192q13 0 22.5 9.5t9.5 22.5zm25-800v448q0 26-19 45t-45 19h-448q-26 0-45-19t-19-45 19-45l138-138q-148-137-349-137-134 0-250 65t-186 179q-11 17-53 117-8 23-30 23h-199q-13 0-22.5-9.5t-9.5-22.5v-7q65-268 270-434.5t480-166.5q146 0 284 55.5t245 156.5l130-129q19-19 45-19t45 19 19 45z" /></svg>
				<div class="extension-info">
					<h3>Meta Box Updater</h3>
					<p><?php esc_html_e( 'Automatically updates all Meta Box extensions within the WordPress Admin area.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/meta-box-updater/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Free Download', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1596 476q14 14 28 36h-472v-472q22 14 36 28zm-476 164h544v1056q0 40-28 68t-68 28h-1344q-40 0-68-28t-28-68v-1600q0-40 28-68t68-28h800v544q0 40 28 68t68 28zm160 736v-64q0-14-9-23t-23-9h-704q-14 0-23 9t-9 23v64q0 14 9 23t23 9h704q14 0 23-9t9-23zm0-256v-64q0-14-9-23t-23-9h-704q-14 0-23 9t-9 23v64q0 14 9 23t23 9h704q14 0 23-9t9-23zm0-256v-64q0-14-9-23t-23-9h-704q-14 0-23 9t-9 23v64q0 14 9 23t23 9h704q14 0 23-9t9-23z" /></svg>
				<div class="extension-info">
					<h3>Meta Box Template</h3>
					<p><?php esc_html_e( 'Define custom meta boxes and custom fields easier with templates.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/meta-box-template/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Learn More', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1152 1376v-160q0-14-9-23t-23-9h-96v-512q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v160q0 14 9 23t23 9h96v320h-96q-14 0-23 9t-9 23v160q0 14 9 23t23 9h448q14 0 23-9t9-23zm-128-896v-160q0-14-9-23t-23-9h-192q-14 0-23 9t-9 23v160q0 14 9 23t23 9h192q14 0 23-9t9-23zm640 416q0 209-103 385.5t-279.5 279.5-385.5 103-385.5-103-279.5-279.5-103-385.5 103-385.5 279.5-279.5 385.5-103 385.5 103 279.5 279.5 103 385.5z" /></svg>
				<div class="extension-info">
					<h3>Meta Box Tooltip</h3>
					<p><?php esc_html_e( 'Display help information for fields using beautiful tooltips.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/meta-box-tooltip/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Learn More', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1664 960q-152-236-381-353 61 104 61 225 0 185-131.5 316.5t-316.5 131.5-316.5-131.5-131.5-316.5q0-121 61-225-229 117-381 353 133 205 333.5 326.5t434.5 121.5 434.5-121.5 333.5-326.5zm-720-384q0-20-14-34t-34-14q-125 0-214.5 89.5t-89.5 214.5q0 20 14 34t34 14 34-14 14-34q0-86 61-147t147-61q20 0 34-14t14-34zm848 384q0 34-20 69-140 230-376.5 368.5t-499.5 138.5-499.5-139-376.5-368q-20-35-20-69t20-69q140-229 376.5-368t499.5-139 499.5 139 376.5 368q20 35 20 69z" /></svg>
				<div class="extension-info">
					<h3>Meta Box Show Hide</h3>
					<p><?php esc_html_e( 'Toggle meta boxes by page template, post format or taxonomy using JS.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/meta-box-show-hide/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Learn More', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M224 1536h608v-1152h-640v1120q0 13 9.5 22.5t22.5 9.5zm1376-32v-1120h-640v1152h608q13 0 22.5-9.5t9.5-22.5zm128-1216v1216q0 66-47 113t-113 47h-1344q-66 0-113-47t-47-113v-1216q0-66 47-113t113-47h1344q66 0 113 47t47 113z" /></svg>
				<div class="extension-info">
					<h3>Meta Box Columns</h3>
					<p><?php esc_html_e( 'Display fields more beautiful by putting them into 12-columns grid.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/meta-box-columns/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Learn More', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 2048 1792" xmlns="http://www.w3.org/2000/svg"><path d="M681 1399l-50 50q-10 10-23 10t-23-10l-466-466q-10-10-10-23t10-23l466-466q10-10 23-10t23 10l50 50q10 10 10 23t-10 23l-393 393 393 393q10 10 10 23t-10 23zm591-1067l-373 1291q-4 13-15.5 19.5t-23.5 2.5l-62-17q-13-4-19.5-15.5t-2.5-24.5l373-1291q4-13 15.5-19.5t23.5-2.5l62 17q13 4 19.5 15.5t2.5 24.5zm657 651l-466 466q-10 10-23 10t-23-10l-50-50q-10-10-10-23t10-23l393-393-393-393q-10-10-10-23t10-23l50-50q10-10 23-10t23 10l466 466q10 10 10 23t-10 23z" /></svg>
				<div class="extension-info">
					<h3>Meta Box Include Exclude</h3>
					<p><?php esc_html_e( 'Show or hide meta boxes whenever and for whomever you choose.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/meta-box-include-exclude/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Learn More', 'meta-box' ); ?></a>
			</div>
		</div>
		<div class="extension">
			<div class="extension-inner">
				<svg viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M384 1184v64q0 13-9.5 22.5t-22.5 9.5h-64q-13 0-22.5-9.5t-9.5-22.5v-64q0-13 9.5-22.5t22.5-9.5h64q13 0 22.5 9.5t9.5 22.5zm0-256v64q0 13-9.5 22.5t-22.5 9.5h-64q-13 0-22.5-9.5t-9.5-22.5v-64q0-13 9.5-22.5t22.5-9.5h64q13 0 22.5 9.5t9.5 22.5zm0-256v64q0 13-9.5 22.5t-22.5 9.5h-64q-13 0-22.5-9.5t-9.5-22.5v-64q0-13 9.5-22.5t22.5-9.5h64q13 0 22.5 9.5t9.5 22.5zm1152 512v64q0 13-9.5 22.5t-22.5 9.5h-960q-13 0-22.5-9.5t-9.5-22.5v-64q0-13 9.5-22.5t22.5-9.5h960q13 0 22.5 9.5t9.5 22.5zm0-256v64q0 13-9.5 22.5t-22.5 9.5h-960q-13 0-22.5-9.5t-9.5-22.5v-64q0-13 9.5-22.5t22.5-9.5h960q13 0 22.5 9.5t9.5 22.5zm0-256v64q0 13-9.5 22.5t-22.5 9.5h-960q-13 0-22.5-9.5t-9.5-22.5v-64q0-13 9.5-22.5t22.5-9.5h960q13 0 22.5 9.5t9.5 22.5zm128 704v-832q0-13-9.5-22.5t-22.5-9.5h-1472q-13 0-22.5 9.5t-9.5 22.5v832q0 13 9.5 22.5t22.5 9.5h1472q13 0 22.5-9.5t9.5-22.5zm128-1088v1088q0 66-47 113t-113 47h-1472q-66 0-113-47t-47-113v-1088q0-66 47-113t113-47h1472q66 0 113 47t47 113z" /></svg>
				<div class="extension-info">
					<h3>MB Custom Taxonomy</h3>
					<p><?php esc_html_e( 'Create and manage custom taxonomies with an easy-to-use interface in WordPress.', 'meta-box' ); ?></p>
				</div>
			</div>
			<div class="extension-action">
				<a class="button" target="_blank" href="https://metabox.io/plugins/custom-taxonomy/?utm_source=WordPress&utm_medium=link&utm_campaign=plugin"><?php esc_html_e( 'Free Download', 'meta-box' ); ?></a>
			</div>
		</div>
	</div>
</div>
